---
title: "Dossier blanc - Pour l’inscription de l’Éducation permanente (FWB) au Patrimoine culturel immatériel de l’UNESCO"
slug: "ep-fwb-patrimoine-immateriel-unesco"
date: 2025-09-11
lastmod: 2025-09-11
draft: false
summary: "Plaidoyer formel et réflexif en faveur de la reconnaissance de l’Éducation permanente de la Fédération Wallonie-Bruxelles au Patrimoine culturel immatériel (UNESCO), avec analyse critique des enjeux."
description: "Historique, cadre décrétal, valeur patrimoniale, bénéfices attendus, risques de patrimonialisation et propositions de sauvegarde."
tags: ["EP", "Société"]
categories: ["Dossier","Société"]
toc: true
images:
  - "https://dl.ouaisfi.eu/1160/images/share-default.jpg"
featuredImage: "https://dl.ouaisfi.eu/1160/images/share-default.jpg"
---

{{< admonition type=quote title="Résumé" open=true >}}
Ce dossier blanc propose la reconnaissance de l’Éducation permanente de la Fédération Wallonie-Bruxelles au Patrimoine culturel immatériel de l’UNESCO.  
Il en expose l’ancrage historique, le cadre décrétal, la valeur patrimoniale et les bénéfices attendus, tout en discutant les enjeux critiques (risque de muséification, charges administratives, préservation de l’indépendance).
{{< /admonition >}}

## Lecture intégrée - Volet A
<iframe
  src="https://dl.ouaisfi.eu/pdfs/plaidoyer-ep-unesco-gpt.pdf#toolbar=1"
  title="PDF Demo"
  width="100%" height="600"
  loading="lazy"></iframe>

<p><small>Note : l’affichage et la toolbar dépendent du navigateur/lecteur PDF.</small></p>

---

<div class="cta-row" style="display:flex;gap:1rem;flex-wrap:wrap;justify-content:center">

<a class="button" href="https://dl.ouaisfi.eu/pdfs/plaidoyer-ep-unesco-gpt.pdf#toolbar=1" download
   style="padding:.8rem 1rem;border-radius:.8rem;
          border:1px solid #7fb069;
          background:rgba(127,176,105,.15);
          color:#7fb069;font-weight:700;text-decoration:none;
          box-shadow:0 0 15px #7fb069,0 0 40px #7fb069;
          animation:pulse 3s infinite alternate">
  🟣 Télécharger (PDF)
</a>
<p></p>

<a class="button" href="https://dl.ouaisfi.eu/pdfs/plaidoyer-ep-unesco-gpt.docx" download
   style="padding:.8rem 1rem;border-radius:.8rem;
          border:1px solid #b19cd9;
          background:rgba(177,156,217,.15);
          color:#b19cd9;font-weight:700;text-decoration:none;
          box-shadow:0 0 10px #b19cd9,0 0 30px #b19cd9;
          animation:pulse 2s infinite alternate">
  🟢 Télécharger (Docx)
</a>

</div>


---

# Plaidoyer pour la reconnaissance de l’Éducation permanente en tant que patrimoine culturel immatériel de l’UNESCO

## Introduction
L’Éducation permanente, telle qu’elle est pratiquée en Fédération Wallonie-Bruxelles (FWB), constitue bien plus qu’un ensemble de programmes éducatifs pour adultes. C’est un véritable héritage culturel vivant, ancré dans l’histoire sociale belge francophone et tourné vers l’émancipation citoyenne. Ce plaidoyer propose d’argumenter en faveur de la reconnaissance de l’Éducation permanente de la FWB comme élément du patrimoine culturel immatériel de l’humanité par l’UNESCO. Nous examinerons d’abord ce qu’est l’Éducation permanente et en quoi elle s’inscrit dans une tradition culturelle spécifique. Ensuite, nous montrerons comment cette pratique répond aux critères du patrimoine immatériel, avant d’évaluer les bénéfices attendus d’une telle reconnaissance. Enfin, nous adopterons un regard critique et réflexif sur cette démarche, en soulignant les enjeux et défis potentiels liés à l’inscription de l’Éducation permanente au patrimoine immatériel. 

## Qu’est-ce que l’Éducation permanente en Fédération Wallonie-Bruxelles ?
L’Éducation permanente (EP) en FWB est une démarche éducative, culturelle et citoyenne visant à renforcer la conscience critique et la participation active des citoyens tout au long de la vie. Le service public de l’Éducation permanente la définit comme « une démarche visant l’analyse critique de la société, la stimulation d’initiatives démocratiques et collectives, le développement de la citoyenneté active et l’exercice des droits sociaux, culturels, environnementaux et économiques, dans une perspective d’émancipation individuelle et collective des publics ». En clair, l’Éducation permanente outille les individus (principalement adultes) pour comprendre les réalités sociales, agir collectivement et exercer pleinement leurs droits, contribuant ainsi à une société plus juste. 

### Racines historiques et ancrage culturel
Le modèle belge francophone de l’Éducation permanente puise ses racines dans le mouvement de l’éducation populaire du début du XXᵉ siècle. Dès les années 1920, en parallèle à la réduction du temps de travail (journée de 8 h), des initiatives socioculturelles destinées aux travailleurs ont vu le jour, dites « œuvres complémentaires à l’école ». Des arrêtés royaux de 1921 et 1925 ont soutenu ces premières actions d’émancipation culturelle et sociale des classes populaires. Cette dynamique s’amplifie après 1945 : la diversification des associations et l’élargissement de leurs programmes conduisent à un arrêté en 1971, qui emploie pour la première fois le terme « éducation permanente » et élargit la cible à « tous les citoyens ».  
Le **décret du 8 avril 1976** pose les bases légales (reconnaissance/subventionnement). L’**actuel décret du 17 juillet 2003**, révisé en 2018, consacre l’EP dans le **champ de la culture**, avec un **soutien structurel public**, spécificité remarquable en Europe. L’EP en FWB est à la fois politique culturelle et mouvement social d’éducation non formelle, en résonance avec « éducation à la citoyenneté » et « apprentissage tout au long de la vie ».

### Missions et valeurs
Selon l’art. 1 du décret 2003, les organisations d’EP visent à développer chez les adultes :  
- **Conscience critique** de la société ;  
- **Capacités d’analyse, de choix, d’action et d’évaluation** ;  
- **Attitudes de responsabilité et de participation** à la vie sociale, culturelle, économique et politique.  

Concrètement : travail de terrain pour la citoyenneté active et la critique constructive. Environ **280 associations** reconnues, ciblant divers publics (avec attention aux personnes **socio-culturellement défavorisées**) et **± 2 300 ETP** employés.  
Le décret 2003 structure l’action en **quatre axes** : (1) participation/éducation/formation citoyenne ; (2) formation des animateurs/acteurs associatifs ; (3) production d’analyses/études/outils pédagogiques ; (4) sensibilisation et information du public. Finalité partagée : **« construire une société plus juste, démocratique et solidaire »** en dotant les citoyens des moyens d’agir de façon autonome.

**En synthèse** : l’EP en FWB est un mouvement socio-culturel structuré et soutenu par la puissance publique, prolongeant l’éducation populaire, transmettant **savoirs critiques** et **valeurs citoyennes** d’une génération à l’autre — ce qui lui confère déjà une dimension de **patrimoine immatériel vivant**.

## L’Éducation permanente : un patrimoine culturel immatériel vivant
La Convention UNESCO (2003) définit le **patrimoine culturel immatériel (PCI)** comme les **pratiques et expressions vivantes** (traditions orales, arts du spectacle, **pratiques sociales**, rituels, savoir-faire, etc.), **transmises**, porteuses d’**identité** et de **continuité**. À ce titre, l’EP — pratique sociale et culturelle de **transmission** de connaissances et de valeurs — répond aux critères d’un PCI digne de reconnaissance.

### Transmission intergénérationnelle
L’EP s’inscrit dans une **transmission continue** : méthodes participatives, savoir-faire associatif, pensée critique se transmettent via animateurs, formateurs et militants. De nombreuses organisations ont une **longue histoire** (universités populaires, alphabétisation, mouvements de jeunesse…). Les anciens forment les nouveaux ; des participants deviennent bénévoles/animateurs. Pratique **vivante et recréée**, adaptée aux enjeux contemporains (numérique, diversité, climat), sans perdre ses valeurs d’émancipation et de solidarité.

### Identité et cohésion
L’UNESCO insiste : l’importance du PCI tient à la **richesse des connaissances/savoir-faire** qu’il transmet, créant **lien social** et **sentiment d’identité/continuité**. L’EP forge une **culture de l’engagement** propre à la FWB (participation associative, débats, formations citoyennes), espace de rencontre **inter-publics** (âges, origines, milieux). Elle agit comme facteur de **cohésion** et de **dialogue interculturel**. Elle participe à l’**identité culturelle** wallonne et bruxelloise (héritage de progrès social, égalité, fraternité). Reconnaître l’EP, c’est reconnaître l’**esprit d’émancipation collective** comme héritage immatériel.

### Portée inclusive et universelle
Le PCI est **inclusif** et **représentatif** : ancré localement, **pertinent universellement**. La spécificité FWB (cadre public/culturel) s’inscrit dans un mouvement global d’**éducation tout au long de la vie** et de **citoyenneté**. L’EP FWB pourrait servir de **modèle** et d’**inspiration** — affirmation que la **transmission des savoirs citoyens** et l’**empowerment** sont des trésors culturels à préserver. Communautés locales et associations sont les **gardiennes** de la pratique, en cohérence avec l’exigence UNESCO de **consentement/participation** communautaires.

## Intérêts et bénéfices d’une reconnaissance UNESCO
### Sauvegarde et pérennisation
Le label offre **visibilité internationale** et **levier de sauvegarde**. Aucune tradition n’est à l’abri des aléas sociopolitiques ; la reconnaissance renforce **fierté** et **attachement**, incite les autorités à **soutenir**. Mesures de sauvegarde : **archives orales**, **mentorat intergénérationnel**, **documentation** de méthodes, intégration dans **formations**. L’UNESCO requiert des **plans de sauvegarde** : opportunité de formaliser et de pérenniser.

### Rayonnement et partage
Plateforme mondiale : l’EP rejoindrait carnaval de Binche, culture de la bière, culture foraine, etc. **Conférences**, **échanges internationaux**, partage d’**expertise** (éducation non formelle, démocratie, paix). Accès à **réseaux** et **bonnes pratiques**, ateliers de **capacitation**. Enrichissement mutuel par **apprentissages croisés**.

### Légitimité accrue
Au niveau interne : prestige symbolique, meilleure **compréhension publique** du rôle de l’EP, **participation** potentiellement accrue. Signal aux pouvoirs publics pour **maintien/renforcement** des soutiens. Effet d’**entraînement** possible en Belgique (Flandre, CG) et à l’international.

## Regard critique et réflexif sur la démarche
### Éviter la « muséification »
Risque de **figer** une pratique **souple et innovante**. Réponse : souligner son **caractère évolutif**, préserver la **maîtrise** par les associations. **Co-construction** du dossier avec la base (FESEFA, CSEP, réseaux), en cohérence avec les **valeurs démocratiques** du secteur.

### Coûts et contraintes
Candidature exigeante (documentation, consentements, plan de sauvegarde, **rapports périodiques**). Question du **coût d’opportunité** ; mais la formalisation nourrit **mémoire et vision partagée** et les retombées compensent l’investissement. Intégrer les obligations dans les **processus existants** (rapports d’activité), avec **coordination** par l’administration EP.

### Préserver l’esprit critique et l’indépendance
L’ADN de l’EP est **critique** et **indépendant**. La reconnaissance ne doit pas **édulcorer** les contenus. Affirmer que **diversité des opinions** et **liberté d’expression** font **partie** de l’élément patrimonial. L’UNESCO **reconnaît**, n’**ingère** pas.

### Intersections et transversalité
Ne pas **réduire** l’EP au seul culturel : liens avec **école** (pédagogies actives), **patrimoines/mémoire** (médiation, histoire sociale), **développement durable**, **économie sociale**, **médias et info** (éducation critique aux médias). Le dossier doit **rendre visibles** ces intersections.

## Conclusion
Reconnaître l’Éducation permanente de la FWB comme patrimoine culturel immatériel de l’UNESCO serait une étape majeure : héritage **vivant** de l’éducation populaire, **transmis**, source d’**identité**, de **cohésion** et d’**action démocratique**. Les bénéfices sont significatifs (pérennisation, rayonnement, légitimité), à condition de **patrimonialiser sans figer**, **formaliser sans bureaucratiser**, **valoriser sans récupérer**. Bien préparée et portée par les **communautés**, la reconnaissance peut **revigorer** la pratique plutôt que la figer. C’est affirmer que la **culture démocratique** et l’**émancipation par le savoir** constituent un **patrimoine de l’humanité**.

---

## Références (sélection)
- Portail Éducation permanente FWB — Définition, historique, cadre décrétal.  
- Décret du 17 juillet 2003 relatif à l’Éducation permanente (FWB).  
- Lire et Écrire — Présentation et enjeux de l’EP.  
- ADDE — Dossier Éducation permanente.  
- UNESCO — Convention (2003) & « Qu’est-ce que le PCI ? ».  
- Culture.be — Exemples de reconnaissances récentes (culture foraine).  



---

<div class="cta-row" style="display:flex;gap:1rem;flex-wrap:wrap;justify-content:center">

<a class="button" href="https://dl.ouaisfi.eu/pdfs/dossier-candidature.pdf#toolbar=1" download
   style="padding:.8rem 1rem;border-radius:.8rem;
          border:1px solid #7fb069;
          background:rgba(127,176,105,.15);
          color:#7fb069;font-weight:700;text-decoration:none;
          box-shadow:0 0 15px #7fb069,0 0 40px #7fb069;
          animation:pulse 3s infinite alternate">
  🟣 Dossier de Candidature
</a>
<p></p>

<a class="button" href="/TOUT.zip" download
   style="padding:.8rem 1rem;border-radius:.8rem;
          border:1px solid #b19cd9;
          background:rgba(177,156,217,.15);
          color:#b19cd9;font-weight:700;text-decoration:none;
          box-shadow:0 0 10px #b19cd9,0 0 30px #b19cd9;
          animation:pulse 2s infinite alternate">
  🟢 Télécharger TOUT
</a>

</div>


---

## Lecture intégrée - Volet B
<iframe
  src="https://dl.ouaisfi.eu/pdfs/plaidoyer-ep-unesco-claude.pdf#toolbar=1"
  title="PDF Demo"
  width="100%" height="600"
  loading="lazy"></iframe>

<p><small>Note : l’affichage et la toolbar dépendent du navigateur/lecteur PDF.</small></p>

---